; NAME:
;  rdmap_insol
; PURPOSE: (one line)
;  Read Stansberry map of Triton and calculate the daily averaged insolation
; CALLING SEQUENCE:
;  map = rdmap_insol(sslat)
; INPUTS:
;  sslat - the subsolar latitude in degrees
; OUTPUTS:
;  map - 
;   360 by 180.  Pixels are 1-deg wide.
;   Pixel 0,0 runs from latitude -90 to -89 and East longitude 0 to 1.
;  lat_deg - the latitude in degrees (360 x 180 array)
;  lon_deg - the East longitude in degrees (360 x 180 )
;  daily averaged insolation in erg/cm^2/s
; COMMON BLOCKS:
;  None
; RESTRICTIONS:
;  sslat must be -45 or -50
; MODIFICATION HISTORY:
;  Written 2007 June 26, by Leslie Young, SwRI
;-

function rdmap_insol, sslat, lat_deg, lon_deg

    physconstants  ; set up !phys.sigma, etc
    deg = !dpi/180.d
    
    abmap = rdmap_triton_stans92(sslat, lat_deg, lon_deg)

    mumap = insolfac(sslat*deg, lat_deg * deg)
    eabsmap = mumap * (1. - abmap) * 1.373e6/(30.08^2.)

    return, eabsmap

end

