; NAME:
;  rdmap_scutoff
; PURPOSE: (one line)
;  Return 1 where insolation < cutoff
; CALLING SEQUENCE:
;  map = rdmap_scutoff(sslat)
; INPUTS:
;  insolation in erg/cm^2/s
;  sslat - the subsolar latitude in degrees
; OUTPUTS:
;  map - 
;   360 by 180.  Pixels are 1-deg wide.
;   Pixel 0,0 runs from latitude -90 to -89 and East longitude 0 to 1.
;  lat_deg - the latitude in degrees (360 x 180 array)
;  lon_deg - the East longitude in degrees (360 x 180 )
; COMMON BLOCKS:
;  None
; RESTRICTIONS:
;  sslat must be -45 or -50
; MODIFICATION HISTORY:
;  Written 2007 June 26, by Leslie Young, SwRI
;-

function rdmap_scutoff, scutoff, sslat, lat_deg, lon_deg


    eabsmap = rdmap_insol( sslat, lat_deg, lon_deg) 

    m = rebin( float(rebin(eabsmap,3600,1800) lt scutoff), 360,180)

    return, m

end

