function rdmap_trimap1, lat_deg, lon_deg

    fn = '~/reference/maps/Triton/trimap1/trimap1.bmp'
    if not isfile(fn) then stop

    map_tc = read_bmp(fn)
    r = map_tc[0,*,*]
    g = map_tc[1,*,*]
    b = map_tc[2,*,*]
    nxnyn, r, nx, ny

    white = where(r gt 254 and g gt 254 and b gt 254, nwhite)
    badpix = bytarr(nx,ny)
    if nwhite gt 0 then badpix[white] = 1

    ; loop over latitude
    map_tc[*,*,1] = map_tc[*,*,8]
    map_tc[*,*,0] = map_tc[*,*,8]
    for row = 200,1000,200 do begin
        for i=0,6 do map_tc[*,*,row+i] = map_tc[*,*,row+7]
        for i=1,7 do map_tc[*,*,row-i] = map_tc[*,*,row-8]
    endfor
    for row = 1194,1199 do map_tc[*,*,row] = map_tc[*,*,1193]

    ; loop over longitude
    for col=0,6 do map_tc[*,col,*] = map_tc[*,7,*]
    for col = 200,2200,200 do begin
        for i=0,6 do map_tc[*,col+i,*] = map_tc[*,col+7,*]
        for i=1,7 do map_tc[*,col-i,*] = map_tc[*,col-8,*]
    endfor
    for col=2393,2399 do map_tc[*,col,*] = map_tc[*,2392,*]
    
    map_v2 = truecolorconv(map_tc)

    map_v2 = shift(map_v2,1200, 0)

    dlon = 360./nx
    dlat = 180./nx
    lon_deg = arrgen(dlon/2, 360-dlon/2, dlon) # replicate(1,ny)
    lat_deg = replicate(1,nx) # arrgen(-90 + dlat/2, 90-dlat/2, 1.)

    return, map_v2

end
