;+
; NAME:
;  rdmap_triton_mcewen
; PURPOSE: (one line)
;  Read the McEwen maps of Triton
; CALLING SEQUENCE:
;  rdmap_triton_mcewen, lat_deg, lon_deg
; INPUTS:
; OUTPUTS:
;  map - 
;   360 by 180.  Pixels are 1-deg wide.
;   Pixel 0,0 runs from latitude -90 to -89 and East longitude 0 to 1.
;  lat_deg - the latitude in degrees (360 x 180 array)
;  lon_deg - the East longitude in degrees (360 x 180 )
; COMMON BLOCKS:
;  None
; RESTRICTIONS:
; MODIFICATION HISTORY:
;  Written 2007 June 26, by Leslie Young, SwRI
;-

function rdmap_triton_mcewen90, lat_deg, lon_deg

    ; McEwen maps are 551 x 278, left edge is 0 longitude.
    ; 
    ; if x = pixel numner in McEwen and lat = deg of E longitude then 
    ; lon = dlon (x + 0.5) or x = lon/dlon - 0.5
    ; lat = -90 + dlat (y + 0.5) or y = (lat + 90)/dlat - 0.5

    nx = 551
    ny = 278
    dlon = 360./nx
    dlat = 180./ny
    lon = (findgen(360) + 0.5)
    lat = (findgen(180) + 0.5 - 90)
    x = lon/dlon - 0.5
    xi = round(x)
    y = (lat + 90)/dlat - 0.5
    yj = round(y)

    dir = '../maps/McEwen1990/'
    marr = bytarr(360,180,7)

    for imap=0,6 do begin
        fn = dir + 'McEwen_'+string(imap,for='(I1)')+'.fits'
        d = readfits(fn, /sil)
        for i = 0, 359 do begin
            for j = 0, 179 do begin
                marr[i,j,imap] = ( d[xi[i], yj[j]] ne 0)
            endfor
        endfor
        if imap gt 0 then begin
            marr[*,*,imap] = marr[*,*,imap] and not (marr[*,*,0])
        endif
        if imap eq 5 then begin
            marr[*,*,imap] = marr[*,*,imap] and not (marr[*,*,2])
        endif
    endfor
    
    marr[*,*,6] = marr[*,*,6] and not (marr[*,*,2])
    marr[*,*,5] = marr[*,*,5] and not (marr[*,*,2])

    lon_deg = lon # replicate(1,180)
    lat_deg = replicate(1,360) # lat


    return, marr

end
