; NAME:
;  rdmap_triton_mcewen90colorized
; PURPOSE: (one line)
;  Read the McEwan map with a color similar to Triton
; CALLING SEQUENCE:
;  map = rdmap_triton_mcewen90colorized(lat_deg, lon_deg)
; INPUTS:
; OUTPUTS:
;  map - 
;   360 by 180.  Pixels are 1-deg wide.
;   Pixel 0,0 runs from latitude -90 to -89 and East longitude 0 to 1.
;  lat_deg - the latitude in degrees (360 x 180 array)
;  lon_deg - the East longitude in degrees (360 x 180 )
; COMMON BLOCKS:
;  None
; RESTRICTIONS:
; MODIFICATION HISTORY:
;  Written 2008 May 2, by Leslie Young, SwRI
;-

function rdmap_triton_mcewen90colorized, lat_deg, lon_deg

    geomap = rdmap_triton_mcewen90(lat_deg, lon_deg)

    nxnyn,geomap, nx,ny,n

    r = [0,155,125,255,178,220,220]
    g = [0, 95,105,220,158,200,220]
    b = [0, 95,105,220,175,200,255]

    rc = '000001'xl
    bc = '010000'xl  
    gc = '000100'xl  

    m =  0*geomap
    for i=0,6 do m = m + (rc*r[i] + bc*b[i] + gc*g[i]) * geomap[*,*,i]
    
    rarr = 0*geomap
    garr = 0*geomap
    barr = 0*geomap

;    for i=0,6 do rarr = rarr + r[i] * geomap[*,*,i]
;    for i=0,6 do garr = garr + g[i] * geomap[*,*,i]
;    for i=0,6 do barr = barr + b[i] * geomap[*,*,i]
    
    for i=1,6 do rarr = rarr + r[i] * geomap[*,*,i]
    for i=1,6 do garr = garr + g[i] * geomap[*,*,i]
    for i=1,6 do barr = barr + b[i] * geomap[*,*,i]
    
    rgb = bytarr(3,nx,ny)
    rgb[2,*,*] = barr
    rgb[1,*,*] = garr
    rgb[0,*,*] = rarr

;    tv, rgb, /true

    rgbt = truecolorconv(rgb)

    return, rgbt
    
end
