;+
; NAME:
;  rdmap_triton_stans92
; PURPOSE: (one line)
;  Read the Stansberry 1992 map of Triton
; CALLING SEQUENCE:
;  rdmap_stans92, sslat_deg, lat_deg, lon_deg
; INPUTS:
;  sslat_deg - the subsolar latitude in degrees
; OUTPUTS:
;  map - 
;   360 by 180.  Pixels are 1-deg wide.
;   Pixel 0,0 runs from latitude -90 to -89 and East longitude 0 to 1.
;  lat_deg - the latitude in degrees (360 x 180 array)
;  lon_deg - the East longitude in degrees (360 x 180 )
; COMMON BLOCKS:
;  None
; RESTRICTIONS:
;  sslat must be -45 or -40
; MODIFICATION HISTORY:
;  Written 2007 June 26, by Leslie Young, SwRI
;-

function rdmap_triton_stans92, sslat_deg, lat_deg, lon_deg

    dir = '~/reference/maps/Triton/Stansberry1992/'
    d = fltarr(360,180)
    case sslat_deg of
        -45 : begin
            fn = 'alb3b.sslat135.fits'
            d[*,0:134] = readfits(dir+fn, /sil)
        end

        -50 : begin
            fn = 'alb3b.sslat140.fits'
            d[*,0:129] = readfits(dir+fn, /sil)
        end

        else: begin
            print, 'Sub solar latitude ', sslat_deg, ' deg no allowed'
        end
    endcase

    lon_deg = arrgen(-179.5, 179.5, 1.) # replicate(1,180)
    lat_deg = replicate(1,360) # arrgen(-89.5, 89.5, 1.)

    d = shift(d,180, 0)
    lon_deg = (shift(lon_deg, 180,0) +360) mod 360


    return, d

end
