; NAME:
;  rdwidth_n2
; PURPOSE: (one line)
;  Read the N2 widths
; CALLING SEQUENCE:
;  rdwidth_n2, night, lon, area, areaerr
; INPUTS:
; OUTPUTS:
;  night - string (yymmdd)
;  lon - East longitude (deg)
;  area - integrated band ares
;  areaerr
; MODIFICATION HISTORY:
;  Written 2008 Mar 26, by Leslie Young, SwRI
;-

pro rdwidth_n2, night, lon, area, areaerr

    fn = '~/projects/tritonspex/ms-5yr/tables/20080326widths/data.triton_N2'
    if not isfile(fn) then begin
        print, 'rdwidth_n2: ', fn, ' not found'
        return
    endif
    readcol, fn, night, lon, area, areaerr, $
      /skip, form='A,F,F,F'

end

