;+
; NAME:
;  subsearth_latdeg_of_y
; PURPOSE:
;  sub earth latitude
; CALLING SEQUENCE
;  lat = subsearth_latdeg_of_y(year)
; INPUTS
;  year = year
; OUTPUTS
;  lat_deg
;-

function subsearth_latdeg_of_y,year
    
    naifinit, ker='../spice/kernels.tm'

    deg = !pi/180.
    p = naif_phys(801, utcy2et(year))
    return, p.subobslat / deg
end
