;-----------------------------
; Given t in earthyear AD, give the sub-solar latitude
; from Forget's coefficients to Trafton's mode
;
; example
; print, triton_subsollat([1989,2000, 2007])/deg
;      44.5793      49.6500      48.2783  - if the "c" term were cos()
;       47.113040       51.706195       49.521853
;
; WHY ARE THESE POSITIVE?

function triton_subsollat, t

  a = 0.429870
  b = 0.370543
  c = 0.0225091
  alpha0 = 61.52577 * !pi/180.
  alpha1 = 2.185376 * !pi/180.
  beta0 = -100.79473 * !pi/180.
  beta1 = 0.523169 * !pi/180.
  
  sinphi = a*cos(alpha0-alpha1*t) + $
           b*sin(alpha0-beta0+(beta1-alpha1)*t) + $
           c*sin(alpha0-beta0+(beta1+alpha1)*t)
  return, asin(sinphi)
end
