pro unit_func, arg, param, z, deriv

    deg = !pi/180.

    p =  unit_param2struct(arg, param)
    u = p.u
    f = p.f
    m = p.m
    c = p.c
    s = p.s

    nlon = arg.nlon
    nwl = arg.nwl
    nunit = arg.nunit
 
    lonrad = arg.lon * deg

    coslon = cos(lonrad)
    sinlon = sin(lonrad)
    
    area = fltarr(nlon, nunit)
    for iunit = 0, nunit-1 do begin
        area[*,iunit] = m[iunit] + c[iunit]*coslon + s[iunit]*sinlon
    endfor
    
    csp = fltarr(nlon, nwl) ; calculated spectrum
    for ilon = 0, nlon - 1 do begin
        for iunit = 0, nunit-1 do begin
            csp[ilon,*] = csp[ilon,*] + area[ilon, iunit] * u[iunit, *]
        endfor
        csp[ilon,*] = csp[ilon,*] / f[ilon]
    endfor
    z = reform(transpose(csp), n_elements(csp))  ; 


end
