pro unit_init, arg, param, data, weight

    rd_resampled, wl, sp, badsp, lon_deg, datestr, /lonsort, /fix
    nbad = total(badsp, 1)
    igd = where(nbad lt 20, ngd)
    igd0 = split_contig(igd, igdlen, nsplit)

    nunit = 2
    nlon = n_elements(lon_deg)

    i0 = igd[igd0[1]]
    i1= i0 + igdlen[1] - 1
    
    rd_modelspec,'H2O',wl, sph2o
    rd_modelspec,'N2',wl, spn2, /d
    
    lonbin_resampled, wl[i0:i1], sp[*,i0:i1], badsp[*,i0:i1], lon_deg, msp, esp, wsp, mlon_deg  ; msp[8,400]
    data = reform(transpose(msp), n_elements(msp))  ; [w0 o0 .. wn o0, w0 o1 ... wn o1 etc]
    weight = reform(transpose(wsp), n_elements(msp))

    ; start out with 55% N2+CO+CH4, as with Quirico
    f= [0.834140, 0.815522, 0.810152, 0.824073, 0.816909, 0.813568, 0.821672, 0.823400]

    param = [ sph2o[i0:i1], spn2[i0:i1], f, [.55],[0], [0] ]
    arg = unit_arg(mlon_deg, wl[i0:i1], nunit)

end
