; u = u[nunit, nwl].  Isolated spectra for each unit
; f = f[nlon].  Normalization factor to multiply observed spectra by
; m = f[nunit].  Mean projected area of unit
; c = c[nunit].  Cos(lon) factor
; s = s[nunit].  Sin(lon) factor.

function unit_param2struct, arg, param

    nunit = arg.nunit
    nwl = arg.nwl
    nlon = arg.nlon

    u = fltarr(nunit, nwl)
    f = fltarr(nlon)
    m = fltarr(nunit)
    c = fltarr(nunit)
    s = fltarr(nunit)

    u = transpose( reform(param[0:(nunit*nwl)-1], nwl, nunit) )
    i = nunit*nwl
    f = param[i : i + nlon - 1]
    i = i + nlon
    m[1:nunit-1] = param[i:i+nunit-2]
    i = i + nunit - 1
    c[1:nunit-1] = param[i:i+nunit-2]
    i = i + nunit - 1
    s[1:nunit-1] = param[i:i+nunit-2]
    
    m[0] = 1 - total(m[1:nunit-1])
    c[0] = - total(c[1:nunit-1])
    s[0] = - total(s[1:nunit-1])
    
    return, {u:u, f:f, m:m, c:c, s:s}

end
