;+
; 
; NAME:
;  spexred_outlier
; PURPOSE: (one line)
;  find spectral outliers
; DESCRIPTION:
;  compare a spectrum to a smoothed version
; CATEGORY:
;  spectral analysis
; CALLING SEQUENCE:
;  bad = spexred_outlier(spec)
; INPUTS:
;  spec   - a spectrum
; OPTIONAL INPUT PARAMETERS:
; INPUT KEYWORD PARAMETERS:
;   nbin - number of bins to break the spectrum up into
;   thresh - how many sigma for rejection
;   low - lower limit in units of average spectrum
;   high - upper limit in units of average spectrum
; OUTPUT KEYWORD PARAMETERS:
;  None
; OUTPUTS:
;  bad - byte array.  0 = good, 1 = bad 
; COMMON BLOCKS:
;  None.
; SIDE EFFECTS:
;  None
; RESTRICTIONS:
;  None.
; PROCEDURE:
;  reject points if thresh*sigma higher than high*smooth
;  reject points if thresh*sigma loweer than low*smooth
; MODIFICATION HISTORY:
;  Written by Leslie A. Young, SwRI, 2004 Feb 26
;-

function spexred_outlier, spec, nbin=nbin, ysmo=ysmo

ns = n_elements(spec)
bad=bytarr(ns)
if not keyword_set(nbin) then nbin = 8
if not keyword_set(thresh) then thresh = 5
if not keyword_set(low) then low = 0
if not keyword_set(high) then high = 2
binwidth = floor(ns/nbin)
xmin = findgen(nbin)*binwidth + floor( (ns/2.)-(nbin/2.)*binwidth)
xmax = xmin+binwidth-1
xbin = (xmin+xmax)*0.5
ybin = fltarr(nbin)
ebin = fltarr(nbin)
for i=0,nbin-1 do begin &$
    yy = spec[xmin[i]:xmax[i]] &$
    ybin[i] = median(yy) &$
    ebin[i] = median(abs(yy-ybin[i]))/0.8 &$
end
x=findgen(1024)
xbin=[0,xbin,1023]
ybin=[1.5*ybin[0]-0.5*ybin[1], ybin, 1.5*ybin[nbin-1]-0.5*ybin[nbin-2] ]
ebin=[1.5*ebin[0]-0.5*ebin[1], ebin, 1.5*ebin[nbin-1]-0.5*ebin[nbin-2] ]
ysmo = spl_interp(xbin,ybin,spl_init(xbin,ybin),x)>0
esmo = spl_interp(xbin,ebin,spl_init(xbin,ebin),x)>0
;ysmo = spline(xbin,ybin,findgen(1024), 1.0 )>0
;esmo = spline(xbin,ebin,spl_init(xbin,ebin),findgen(1024))>0
for i=0,ns-1 do begin  
    yavg=ysmo[i]
    eavg=esmo[i]
    y=spec[i]
    res=y-yavg
    if y lt (low*yavg-thresh*eavg) or y gt high*yavg+thresh*eavg then begin
        bad[i] = 1
    endif
endfor

return, bad

end
